package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.SeverityEnum;

import java.util.Date;


/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 22.03.2007
* Time: 15:45:34
*/
public class ErrorUrlInfo {
    private final String url;
    private final Date indexedOn;
    private final Date modTime;
    private final int code;
    private final SeverityEnum severity;
    private final boolean hasInternalLinks;
    private final boolean hasExternalLinks;
    private final Long sitemapId;

    public ErrorUrlInfo(String url, Date indexedOn, Date modTime, int code,
                        SeverityEnum severity, boolean hasInternalLinks,
                        boolean hasExternalLinks, Long sitemapId) {
        this.url = url;
        this.indexedOn = indexedOn;
        this.modTime = modTime;
        this.code = code;
        this.severity = severity;
        this.hasInternalLinks = hasInternalLinks;
        this.hasExternalLinks = hasExternalLinks;
        this.sitemapId = sitemapId;
    }

    public String getUrl() {
        return url;
    }

    public Date getIndexedOn() {
        return indexedOn;
    }

    public Date getModTime() {
        return modTime;
    }

    public int getCode() {
        return code;
    }

    public SeverityEnum getSeverity() {
        return severity;
    }

    public boolean hasExternalLinks() {
        return hasExternalLinks;
    }

    public boolean hasInternalLinks() {
        return hasInternalLinks;
    }

    public Long getSitemapId() {
        return sitemapId;
    }
}
