package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.UpdateStateEnum;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

import java.util.Date;

public class FastHostInfo extends ShortHostInfo {
    private UpdateStateEnum updateState;
    private Long urls;
    private boolean isVirused;
    private Integer tcy;
    private Long indexCount;
    private Date indexCountCacheUpdateTime;
    private String spiderIp;
    private Date lastAccess;
    private HostStatusInfo hostStatusInfo;
    private Date hostInfoStatusDate;

    public FastHostInfo(long id, String name, VerificationStateEnum verificationState,
                        VerificationTypeEnum verificationType) {
        super(id, name, verificationState, verificationType);
        this.hostStatusInfo = new HostStatusInfo(null, null, null, null, null, null, null);
    }

    public void setHostDbFields(final UpdateStateEnum updateState, final Long urls,
                                final boolean isVirused, final Integer tcy,
                                final Long indexCount,
                                final Date indexCountCacheUpdateTime,
                                HostInfoStatusEnum hostInfoStatus,
                                Date hostInfoStatusDate,
                                String spiderIp,
                                HostInfoStatusEnum hostInfoStatusHtarc, final Integer penaltyHtarc,
                                HostInfoStatusEnum hostInfoStatusYa, final Integer penaltyYa,
                                final Date lastAccess,
                                Boolean htarcInIndex,
                                Boolean prevInIndex) {
        this.updateState = updateState;
        this.urls = urls;
        this.isVirused = isVirused;
        this.tcy = tcy;
        this.indexCount = indexCount;
        this.indexCountCacheUpdateTime = indexCountCacheUpdateTime;
        this.spiderIp = spiderIp;
        this.lastAccess = lastAccess;
        this.hostStatusInfo = new HostStatusInfo(
                hostInfoStatusHtarc, hostInfoStatusYa, hostInfoStatus, penaltyHtarc, penaltyYa, htarcInIndex, prevInIndex);
        this.hostInfoStatusDate = hostInfoStatusDate;
    }

    public UpdateStateEnum getUpdateState() {
        return updateState;
    }

    public Long getUrls() {
        return urls;
    }

    public boolean isVirused() {
        return isVirused;
    }

    public Integer getTcy() {
        return tcy;
    }

    public void setTcy(Integer tcy) {
        this.tcy = tcy;
    }

    public Long getIndexCount() {
        return indexCount;
    }

    public void setIndexCount(Long indexCount) {
        this.indexCount = indexCount;
    }

    public Date getIndexCountCacheUpdateTime() {
        return indexCountCacheUpdateTime;
    }

    public HostInfoStatusEnum getHostInfoStatus() {
        return hostStatusInfo.getHostInfoStatus();
    }

    public HostInfoStatusEnum getCalculatedHostInfoStatus() {
        return hostStatusInfo.getCalculatedHostInfoStatus();
    }

    public String getSpiderIp() {
        return spiderIp;
    }

    public Date getLastAccess() {
        return lastAccess;
    }

    public Date getHostInfoStatusDate() {
        return hostInfoStatusDate;
    }
}
