package ru.yandex.wmconsole.data.info;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum FormatErrorType implements IntEnum {
    ERR_RULE_NOT_SLASH(0),
    ERR_ASTERISK_MULTI(1),
    ERR_HOST_MULTI(2),
    ERR_ROBOTS_HUGE(3),
    ERR_RULE_BEFORE_USER_AGENT(4),
    ERR_RULE_HUGE(5),
    ERR_HOST_FORMAT(6),
    ERR_SITEMAP_FORMAT(7),
    ERR_CRAWL_DELAY_FORMAT(8),
    ERR_CRAWL_DELAY_MULTI(9),
    ERR_CLEAN_PARAM_FORMAT(10),
    WARN_SUSPECT_SYMBOL(11),
    WARN_UNKNOWN_FIELD(12),
    WARN_TRASH(13),
    UNKNOWN_TYPE(14);

    private final int value;
    private static List<FormatErrorType> list = new ArrayList<FormatErrorType>();

    private FormatErrorType(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<FormatErrorType> R = IntEnumResolver.r(FormatErrorType.class);
}
