package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * @author baton
 */
public class FreeVerificationInfo {
    private final String hostName;

    private boolean isDelegated = false;
    private boolean isAutoVerified = false;
    private boolean isVerifiedAtPddAuto = false;

    public FreeVerificationInfo(String hostName, VerificationTypeEnum verificationType) {
        this.hostName = hostName;
        addVerificationType(verificationType);
    }

    public FreeVerificationInfo(String hostName) {
        this.hostName = hostName;
    }

    public void addVerificationType(VerificationTypeEnum verificationType) {
        switch (verificationType) {
            case DELEGATION: {
                isDelegated = true;
                break;
            }
            case AUTO: {
                isAutoVerified = true;
                break;
            }
            case PDD_AUTO: {
                isVerifiedAtPddAuto = true;
                break;
            }
            default: {
                throw new AssertionError("Unknown type of free verification: " + verificationType);
            }
        }
    }

    public String getHostName() {
        return hostName;
    }

    public boolean isDelegated() {
        return isDelegated;
    }

    public boolean isAutoVerified() {
        return isAutoVerified;
    }

    public boolean isVerifiedAtPddAuto() {
        return isVerifiedAtPddAuto;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        FreeVerificationInfo that = (FreeVerificationInfo) o;

        if (hostName != null ? !hostName.toLowerCase().equals(that.hostName.toLowerCase()) : that.hostName != null) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return hostName != null ? hostName.toLowerCase().hashCode() : 0;
    }
}
