package ru.yandex.wmconsole.data.info;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Настройки главной страницы
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 30.01.12
 */
@XmlRootElement(name = "homepage")
public class HomePageOptionsInfo {
    @XmlElement(name = "redirect-to-sites", required = true)
    private final boolean redirectToMySites;

    @XmlElement(name = "promo-tab", required = false)
    private final Integer promoTab;

    @XmlElement(name = "show-tip")
    private final boolean showTip;

    @XmlElement(name = "show-metrika-error")
    private final boolean showMetrikaError;

    public HomePageOptionsInfo() {
        // for JAXB
        throw new UnsupportedOperationException("Don't use default constructor! It is only for JAXB");
    }

    public HomePageOptionsInfo(boolean redirectToMySites, Integer promoTab, boolean showTip, boolean showMetrikaError) {
        this.redirectToMySites = redirectToMySites;
        this.promoTab = promoTab;
        this.showTip = showTip;
        this.showMetrikaError = showMetrikaError;
    }

    public boolean getRedirectToMySites() {
        return redirectToMySites;
    }

    public Integer getPromoTab() {
        return promoTab;
    }

    public boolean getShowTip() {
        return showTip;
    }

    public boolean getShowMetrikaError() {
        return showMetrikaError;
    }

    public HomePageOptionsInfo withRedirectToSites(boolean newRedirectToSites) {
        return new HomePageOptionsInfo(newRedirectToSites, this.promoTab, this.showTip, this.showMetrikaError);
    }

    public HomePageOptionsInfo withPromoTab(Integer newPromoTab) {
        return new HomePageOptionsInfo(this.redirectToMySites, newPromoTab, this.showTip, this.showMetrikaError);
    }

    public HomePageOptionsInfo withShowTip(boolean newShowTip) {
        return new HomePageOptionsInfo(this.redirectToMySites, this.promoTab, newShowTip, this.showMetrikaError);
    }

    public HomePageOptionsInfo withShowMetrikaError(boolean newShowMetrikaError) {
        return new HomePageOptionsInfo(this.redirectToMySites, this.promoTab, this.showTip, newShowMetrikaError);
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        HomePageOptionsInfo that = (HomePageOptionsInfo) o;

        if (redirectToMySites != that.redirectToMySites) {
            return false;
        }
        if (showTip != that.showTip) {
            return false;
        }
        if (promoTab != null ? !promoTab.equals(that.promoTab) : that.promoTab != null) {
            return false;
        }
        if (showMetrikaError != that.showMetrikaError) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = (redirectToMySites ? 1 : 0);
        result = 31 * result + (promoTab != null ? promoTab.hashCode() : 0);
        result = 31 * result + (showTip ? 1 : 0);
        result = 31 * result + (showMetrikaError ? 1 : 0);
        return result;
    }
}
