package ru.yandex.wmconsole.data.info;

import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 15:47:26
 */
public class HostDailyStateInfo {
    private final Date stateDate;
    private int siteErrors;
    private int disallowedByUser;
    private int unsupportedByRobot;

    public HostDailyStateInfo(Date stateDate, int siteErrors, int disallowedByUser, int unsupportedByRobot) {
        this.stateDate = stateDate;
        this.siteErrors = siteErrors;
        this.disallowedByUser = disallowedByUser;
        this.unsupportedByRobot = unsupportedByRobot;
    }

    public Date getStateDate() {
        return stateDate;
    }

    public int getSiteErrors() {
        return siteErrors;
    }

    public int getDisallowedByUser() {
        return disallowedByUser;
    }

    public int getUnsupportedByRobot() {
        return unsupportedByRobot;
    }

    public void addSiteErrors(int siteErrors) {
        this.siteErrors += siteErrors;
    }

    public void addDisallowedByUser(int numDisallowed) {
        this.disallowedByUser += numDisallowed;
    }

    public void addUnsupportedByRobot(int unsupportedByRobot) {
        this.unsupportedByRobot = unsupportedByRobot;
    }
}
