package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.UpdateStateEnum;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

import javax.xml.bind.annotation.XmlTransient;
import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class HostInfo extends ShortHostInfo {
    private final Integer tcy;
    private final Long urlCount;
    private final Long urlErrors;
    private Long indexCount;
    private Long internalLinksCount;
    private Long linksCount;
    private final Date lastAccess;
    private final Date lastAccessHtarc;
    private final Long lastLoaderTime;
    private final Date updatedOn;
    private final Integer docs;
    private final UpdateStateEnum updateState;
    private final Integer sitemapCount;
    private final Boolean virused;
    private final String spiderIp;
    private final HostStatusInfo hostStatusInfo;
    private final Date hostInfoStatusDate;
    private final Long urlsTrend;
    private final Long indexCountTrend;
    private final Long linksCountTrend;
    private final Long urlErrorsTrend;
    private final Long tcyTrend;
    private final boolean isMainMirror;

    private final Long xmlsearchIndexCount;
    private final Date indexCountUpdateTime;
    private final Date linksCountUpdateTime;
    private final Date internalLinksCountUpdateTime;

    public HostInfo(long id, String name, Integer tcy, VerificationStateEnum verificationState,
                    VerificationTypeEnum verificationType, Long urlCount, Long urlErrors, Date lastAccess,
                    Date lastAccessHtarc,
                    Long lastLoaderTime,
                    Date updatedOn, Integer docs, UpdateStateEnum updateState, Long indexCount,
                    Long internalLinksCount, Long linksCount, Integer sitemapCount, Boolean virused,
                    HostInfoStatusEnum hostInfoStatus, String spiderIp,
                    HostInfoStatusEnum hostInfoStatusHtarc, Integer penaltyHtarc,
                    HostInfoStatusEnum hostInfoStatusYa, Integer penaltyYa, Date hostInfoStatusDate, Long urlsTrend,
                    Long indexCountTrend, Long linksCountTrend, Long tcyTrend, Long urlErrorsTrend,
                    Boolean htarcInIndex, Boolean prevInIndex, Long xmlsearchIndexCount,
                    Date indexCountUpdateTime, Date linksCountUpdateTime, Date internalLinksCountUpdateTime,
                    boolean isMainMirror) {
        super(id, name, verificationState, verificationType);
        this.tcy = tcy;
        this.urlCount = urlCount;
        this.urlErrors = urlErrors;
        this.lastAccess = lastAccess;
        this.lastAccessHtarc = lastAccessHtarc;
        this.lastLoaderTime = lastLoaderTime;
        this.updatedOn = updatedOn;
        this.docs = docs;
        this.updateState = updateState;
        this.indexCount = indexCount;
        this.internalLinksCount = internalLinksCount;
        this.linksCount = linksCount;
        this.sitemapCount = sitemapCount;
        this.virused = virused;
        this.spiderIp = spiderIp;
        // статусы
        this.hostStatusInfo = new HostStatusInfo(
                hostInfoStatusHtarc, hostInfoStatusYa, hostInfoStatus, penaltyHtarc, penaltyYa, htarcInIndex, prevInIndex);
        this.hostInfoStatusDate = hostInfoStatusDate;
        // тренды
        this.urlsTrend = urlsTrend;
        this.indexCountTrend = indexCountTrend;
        this.linksCountTrend = linksCountTrend;
        this.tcyTrend = tcyTrend;
        this.urlErrorsTrend = urlErrorsTrend;
        this.isMainMirror = isMainMirror;
        this.xmlsearchIndexCount = xmlsearchIndexCount;
        this.indexCountUpdateTime = indexCountUpdateTime;
        this.linksCountUpdateTime = linksCountUpdateTime;
        this.internalLinksCountUpdateTime = internalLinksCountUpdateTime;
    }

    public HostInfo(UserDbHostInfo userDbHostInfo) {
        super(userDbHostInfo.getId(), userDbHostInfo.getName(), userDbHostInfo.getVerificationState(),
                userDbHostInfo.getVerificationType());
        this.tcy = null;
        this.urlErrors = userDbHostInfo.getUrlErrors();
        this.urlCount = null;
        this.lastAccess = null;
        this.lastAccessHtarc = null;
        this.lastLoaderTime = null;
        this.updatedOn = null;
        this.docs = null;
        this.updateState = null;
        this.indexCount = null;
        this.internalLinksCount = null;
        this.linksCount = null;
        this.sitemapCount = null;
        this.virused = null;
        this.spiderIp = null;
        this.hostStatusInfo = new HostStatusInfo(null, null, null, null, null, null, null);
        this.hostInfoStatusDate = null;
        this.urlsTrend = null;
        this.indexCountTrend = null;
        this.linksCountTrend = null;
        this.tcyTrend = null;
        this.urlErrorsTrend = null;
        this.isMainMirror = userDbHostInfo.isMainMirror();
        this.xmlsearchIndexCount = null;
        this.indexCountUpdateTime = null;
        this.linksCountUpdateTime = null;
        this.internalLinksCountUpdateTime = null;
    }

    public Integer getTcyOrZeroIfLessThanTen() {
        if (tcy == null) {
            return null;
        }
        if (tcy < 10) {
            return 0;
        }

        return tcy;
    }

    public Integer getTcy() {
        return tcy;
    }

    public Long getUrlCount() {
        return urlCount;
    }

    public Long getUrlErrors() {
        return urlErrors;
    }

    public Date getLastAccess() {
        return lastAccess;
    }

    public Date getPenaltyLastAccess() {
        if (hostStatusInfo == null) {
            return null;
        }
        HostInfoStatusEnum status =  hostStatusInfo.getCalculatedHostInfoStatus();
        if (status == null) {
            return lastAccess;
        }
        if (!HostInfoStatusEnum.isWillStatus(status)) {
            // должна быть дата с ya
            return lastAccess;
        } else {
            // должна быть дата с htarc
            return lastAccessHtarc != null ? lastAccessHtarc : lastAccess;
        }
    }

    public Date getUpdatedOn() {
        return updatedOn;
    }

    public Integer getDocs() {
        return docs;
    }

    public UpdateStateEnum getUpdateState() {
        return updateState;
    }

    public Long getIndexCount() {
        return indexCount;
    }

    public Long getInternalLinksCount() {
        return internalLinksCount;
    }

    public Long getLinksCount() {
        return linksCount;
    }

    public Integer getSitemapCount() {
        return sitemapCount;
    }

    public Boolean isVirused() {
        return virused;
    }

    public HostInfoStatusEnum getHostInfoStatus() {
        return hostStatusInfo.getHostInfoStatus();
    }

    public HostInfoStatusEnum getCalculatedHostInfoStatus() {
        return hostStatusInfo.getCalculatedHostInfoStatus();
    }

    public String getSpiderIp() {
        return spiderIp;
    }

    public Date getHostInfoStatusDate() {
        return hostInfoStatusDate;
    }

    public Long getUrlsTrend() {
        return urlsTrend;
    }

    public Long getIndexCountTrend() {
        return indexCountTrend;
    }

    public Long getLinksCountTrend() {
        return linksCountTrend;
    }

    public Long getTcyTrend() {
        return tcyTrend;
    }

    public Long getUrlErrorsTrend() {
        return urlErrorsTrend;
    }

    public Long getLastLoaderTime() {
        return lastLoaderTime;
    }

    public boolean isMainMirror() {
        return isMainMirror;
    }

    public void setIndexCount(Long indexCount) {
        this.indexCount = indexCount;
    }

    public void setInternalLinksCount(Long internalLinksCount) {
        this.internalLinksCount = internalLinksCount;
    }

    public void setLinksCount(Long linksCount) {
        this.linksCount = linksCount;
    }

    @XmlTransient
    public Date getIndexCountUpdateTime() {
        return indexCountUpdateTime;
    }

    @XmlTransient
    public Date getLinksCountUpdateTime() {
        return linksCountUpdateTime;
    }

    @XmlTransient
    public Date getInternalLinksCountUpdateTime() {
        return internalLinksCountUpdateTime;
    }

    @XmlTransient
    public Long getXmlsearchIndexCount() {
        return xmlsearchIndexCount;
    }
}
