package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.LanguageEnum;
import ru.yandex.wmconsole.data.WMCHistoryObjectTypeEnum;
import ru.yandex.wmtools.common.data.IHistoryAction;
import ru.yandex.wmtools.common.data.info.WMUserInfo;

import java.util.Date;

/**
 * @author avhaliullin
 */
public class HostOwnersDraftMessageInfo extends DraftMessageInfo {
    private final long hostsCount;
    private final BriefHostInfo firstHost;

    public HostOwnersDraftMessageInfo(long messageId, WMUserInfo lastEditor, String header, String content,
                                      IHistoryAction state, Date lastAccess, WMCHistoryObjectTypeEnum type,
                                      long hostsCount, BriefHostInfo firstHost, LanguageEnum language) {
        super(messageId, lastEditor, header, content, state, lastAccess, type, language);
        this.hostsCount = hostsCount;
        this.firstHost = firstHost;
    }

    public HostOwnersDraftMessageInfo(DraftMessageInfo draftMessageInfo, long hostsCount, BriefHostInfo firstHost) {
        this(draftMessageInfo.getMessageId(),
                draftMessageInfo.getLastEditor(),
                draftMessageInfo.getHeader(),
                draftMessageInfo.getContent(),
                draftMessageInfo.getState(),
                draftMessageInfo.getLastAccess(),
                draftMessageInfo.getType(),
                hostsCount,
                firstHost,
                draftMessageInfo.getLanguage());
    }

    public long getHostsCount() {
        return hostsCount;
    }

    public BriefHostInfo getFirstHost() {
        return firstHost;
    }
}
