package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;

/**
 * Статус хоста при индексировании с учетом htarc и prew
 * (Появилось в результате рефакторинга как общая часть HostInfo, FastHostInfo, HostUnavailableInfo)
 *
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 29.12.11
 */
public class HostStatusInfo {
    private final HostInfoStatusEnum hostInfoStatusHtarc;
    private final HostInfoStatusEnum hostInfoStatusYa;
    private final HostInfoStatusEnum hostInfoStatus;
    private final Integer penaltyHtarc;
    private final Integer penaltyYa;
    private final Boolean htarcInIndex;
    private final Boolean prevInIndex;

    public HostStatusInfo(
            final HostInfoStatusEnum hostInfoStatusHtarc,
            final HostInfoStatusEnum hostInfoStatusYa,
            final HostInfoStatusEnum hostInfoStatus,
            final Integer penaltyHtarc,
            final Integer penaltyYa,
            final Boolean htarcInIndex,
            final Boolean prevInIndex) {
        this.hostInfoStatusHtarc = hostInfoStatusHtarc;
        this.penaltyHtarc = penaltyHtarc;
        this.hostInfoStatusYa = hostInfoStatusYa;
        this.penaltyYa = penaltyYa;
        this.hostInfoStatus = hostInfoStatus;
        this.htarcInIndex = htarcInIndex;
        this.prevInIndex = prevInIndex;
    }

    public HostInfoStatusEnum getCalculatedHostInfoStatus() {
        if (hostInfoStatusHtarc == null && hostInfoStatusYa == null ||
                htarcInIndex == null && prevInIndex == null) {
            return hostInfoStatus;
        }

        boolean bHtarcInIndex = htarcInIndex != null ? htarcInIndex : false;
        boolean bPrevInIndex = prevInIndex != null ? prevInIndex : false;

        HostInfoStatusEnum calculatedStatus = hostInfoStatusHtarc;
        if (calculatedStatus == null) {
            calculatedStatus = hostInfoStatusYa;
        }

        int X = defineXByHostInfoStatusEnum(calculatedStatus);
        if (X == 0) {
            return hostInfoStatus;
        }

        int ph = ((hostInfoStatusHtarc == null) || (penaltyHtarc == null)) ? 0 : penaltyHtarc;
        int pp = ((hostInfoStatusYa == null) || (penaltyYa == null)) ? 0 : penaltyYa;
        if (hostInfoStatus != null && hostInfoStatusYa != null && hostInfoStatusHtarc != hostInfoStatusYa) {
            // Если статусы не совпадают, то не учитываем пенальти с ya
            pp = 0;
        }

        HostInfoStatusEnum res = hostInfoStatus;
        if (ph < X) {
            if ((X - 4) <= pp && bPrevInIndex) {
                res = defineWrnStatusByStatus(calculatedStatus);
            }
        } else {
            if (bHtarcInIndex) {
                if (pp < (X - 4) && bPrevInIndex) {
                    res = defineWillStatusByStatus(calculatedStatus);
                } else {
                    res = calculatedStatus;
                }
            } else if (pp >= (X - 4) && bPrevInIndex) {
                res = calculatedStatus;
            }
        }

        if (HostInfoStatusEnum.DISALLOW_YANDEX.equals(res)) {
            res = HostInfoStatusEnum.DISALLOW;
        }

        return res;
    }

    private int defineXByHostInfoStatusEnum(HostInfoStatusEnum status) {
        switch (status) {
            case CONNECTION_FAILED:
                return 10;
            case DNS_ERROR:
                return 10;
            case DISALLOW:
                return 6;
            case DISALLOW_YANDEX:
                return 6;
        }
        return 0;
    }

    private HostInfoStatusEnum defineWillStatusByStatus(HostInfoStatusEnum status) {
        switch (status) {
            case CONNECTION_FAILED:
                return HostInfoStatusEnum.WILL_CONNECTION_FAILED;
            case DNS_ERROR:
                return HostInfoStatusEnum.WILL_DNS_ERROR;
            case DISALLOW:
                return HostInfoStatusEnum.WILL_DISALLOW;
            case DISALLOW_YANDEX:
                return HostInfoStatusEnum.WILL_DISALLOW;
        }
        return null;
    }

    private HostInfoStatusEnum defineWrnStatusByStatus(HostInfoStatusEnum status) {
        switch (status) {
            case CONNECTION_FAILED:
                return HostInfoStatusEnum.WARN_CONNECTION_FAILED;
            case DNS_ERROR:
                return HostInfoStatusEnum.WARN_DNS_ERROR;
            case DISALLOW:
                return HostInfoStatusEnum.WARN_DISALLOW;
            case DISALLOW_YANDEX:
                return HostInfoStatusEnum.WARN_DISALLOW;
        }
        return null;
    }

    public HostInfoStatusEnum getHostInfoStatusHtarc() {
        return hostInfoStatusHtarc;
    }

    public HostInfoStatusEnum getHostInfoStatusYa() {
        return hostInfoStatusYa;
    }

    public HostInfoStatusEnum getHostInfoStatus() {
        return hostInfoStatus;
    }

    public Integer getPenaltyHtarc() {
        return penaltyHtarc;
    }

    public Integer getPenaltyYa() {
        return penaltyYa;
    }
}
