package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;

import java.util.Date;

/**
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 30.12.11
 */
public class HostUnavailableInfo {
    private final long hostId;
    private final HostStatusInfo status;
    private final String hostName;
    private String spiderIp;
    private final Date lastAccessYa;
    private final Date lastAccessHtarc;

    public HostUnavailableInfo(final long hostId, final String hostName, final HostInfoStatusEnum hostInfoStatusHtarc,
                               final HostInfoStatusEnum hostInfoStatusYa,
                               final HostInfoStatusEnum hostInfoStatus,
                               final Integer penaltyHtarc,
                               final Integer penaltyYa,
                               final Date lastAccessYa,
                               final Date lastAccessHtarc,
                               final Boolean htarcInIndex,
                               final Boolean prevInIndex) {
        this.hostId = hostId;
        this.hostName = hostName;
        this.status = new HostStatusInfo(
                hostInfoStatusHtarc, hostInfoStatusYa, hostInfoStatus, penaltyHtarc, penaltyYa, htarcInIndex, prevInIndex);
        this.spiderIp = null;
        this.lastAccessYa = lastAccessYa;
        this.lastAccessHtarc = lastAccessHtarc;
    }

    public long getHostId() {
        return hostId;
    }

    public HostInfoStatusEnum getCalculatedHostInfoStatus() {
        return status.getCalculatedHostInfoStatus();
    }

    public HostStatusInfo getStatus() {
        return status;
    }

    public String getHostName() {
        return hostName;
    }

    public String getSpiderIp() {
        return spiderIp;
    }

    public void setSpiderIp(String spiderIp) {
        this.spiderIp = spiderIp;
    }

    public Date getLastAccess() {
        HostInfoStatusEnum statusEnum = status.getCalculatedHostInfoStatus();
        if (!HostInfoStatusEnum.isWillStatus(statusEnum)) {
            return lastAccessYa != null ? lastAccessYa : lastAccessHtarc;
        } else {
            return lastAccessHtarc != null ? lastAccessHtarc : lastAccessYa;
        }
    }

    public Date getLastAccessYa() {
        return lastAccessYa;
    }

    public Date getLastAccessHtarc() {
        return lastAccessHtarc;
    }
}
