package ru.yandex.wmconsole.data.info;

import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * User: azakharov
 * Date: 26.10.12
 * Time: 17:08
 */
@XmlRootElement(name = "report-limits")
public class HostsReportLimitsInfo {
    private List<HostLimitInfo> mainUserLimits;
    private List<HostLimitInfo> notMainUserLimits;

    private Long totalLimit;

    public HostsReportLimitsInfo() {
        // for JAXB
    }

    public HostsReportLimitsInfo(
            List<HostLimitInfo> mainUserLimits,
            List<HostLimitInfo> notMainUserLimits,
            Long totalLimit) {
        this.mainUserLimits = mainUserLimits;
        this.notMainUserLimits = notMainUserLimits;
        this.totalLimit = totalLimit;
    }

    public static class HostLimitInfo {
        private long hostId;
        private String hostName;
        private String punycodeHostName;
        private Long mainUserId;
        private String mainUserLogin;
        private Long limit;
        private Long delegatedFrom;
        private String delegatedFromLogin;
        private Long delegatedTo;
        private String delegatedToLogin;
        private Date delegationDate;
        private List<VerifiedUserInfo> verifiedUsers;

        public HostLimitInfo() {
        }

        public HostLimitInfo(long hostId, String hostName, String punycodeHostName, Long mainUserId, String mainUserLogin, Long delegatedFrom, Long delegatedTo, Date delegationDate, Long limit) {
            this.hostId = hostId;
            this.hostName = hostName;
            this.punycodeHostName = punycodeHostName;
            this.mainUserId = mainUserId;
            this.mainUserLogin = mainUserLogin;
            this.delegatedFrom = delegatedFrom;
            this.delegatedTo = delegatedTo;
            this.delegationDate = delegationDate;
            this.limit = limit;
        }

        @XmlElement(name = "host-id")
        public long getHostId() {
            return hostId;
        }

        @XmlElement(name = "host-name")
        public String getHostName() {
            return hostName;
        }

        @XmlElement(name = "punycode-host-name")
        public String getPunycodeHostName() {
            return punycodeHostName;
        }

        @XmlElement(name = "main-user-id")
        public Long getMainUserId() {
            return mainUserId;
        }

        public void setMainUserId(Long mainUserId) {
            this.mainUserId = mainUserId;
        }

        @XmlElement(name = "main-user-login")
        public String getMainUserLogin() {
            return mainUserLogin;
        }

        public void setMainUserLogin(String mainUserLogin) {
            this.mainUserLogin = mainUserLogin;
        }

        @XmlElement(name = "limit")
        public Long getLimit() {
            return limit;
        }

        public void setLimit(Long limit) {
            this.limit = limit;
        }

        @XmlElementWrapper(name = "verified-users")
        @XmlElement(name = "user")
        public List<VerifiedUserInfo> getVerifiedUsers() {
            return verifiedUsers;
        }

        public void setVerifiedUsers(List<VerifiedUserInfo> verifiedUsers) {
            this.verifiedUsers = verifiedUsers;
        }

        public Long getDelegatedFrom() {
            return delegatedFrom;
        }

        public String getDelegatedFromLogin() {
            return delegatedFromLogin;
        }

        public void setDelegatedFromLogin(String delegatedFromLogin) {
            this.delegatedFromLogin = delegatedFromLogin;
        }

        public String getDelegatedToLogin() {
            return delegatedToLogin;
        }

        public void setDelegatedToLogin(String delegatedToLogin) {
            this.delegatedToLogin = delegatedToLogin;
        }

        public Long getDelegatedTo() {
            return delegatedTo;
        }

        public Date getDelegationDate() {
            return delegationDate;
        }
    }

    public static class VerifiedUserInfo {
        private long userId;
        private String login;

        public VerifiedUserInfo() {
            // for JAXB
        }

        public VerifiedUserInfo(long userId, String login) {
            this.userId = userId;
            this.login = login;
        }

        @XmlAttribute(name = "user-id")
        public long getUserId() {
            return userId;
        }

        @XmlAttribute(name = "login")
        public String getLogin() {
            return login;
        }
    }

    @XmlElementWrapper(name = "main-user-hosts-limits")
    @XmlElement(name = "host-limit")
    public List<HostLimitInfo> getMainUserLimits() {
        return mainUserLimits;
    }

    @XmlElementWrapper(name = "not-main-user-hosts-limits")
    @XmlElement(name = "host-limit")
    public List<HostLimitInfo> getNotMainUserLimits() {
        return notMainUserLimits;
    }

    @XmlElement(name = "total-limit")
    public Long getTotalLimit() {
        return totalLimit;
    }
}

