package ru.yandex.wmconsole.data.info;

import java.util.Date;

import ru.yandex.wmconsole.data.sitemaps.SitemapFormatEnum;
import ru.yandex.wmconsole.data.sitemaps.SitemapSourceEnum;
import ru.yandex.wmconsole.data.sitemaps.SitemapTypeEnum;

/**
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 14.02.12
 */
public class MergedSitemapInfo extends SitemapInfo {
    private final SitemapSourceEnum source;
    private Long indexIdCount;

    public MergedSitemapInfo(long id, /*String url,*/ String sitemapHost, String sitemapPath, Date submittedOn,
            boolean fromRobotsTxt, boolean fromUser, SitemapSourceEnum source)
    {
        super(id, /*url,*/ sitemapHost, sitemapPath, submittedOn, fromRobotsTxt, fromUser);
        this.source = source;
    }

    public MergedSitemapInfo(long id, Long indexId, Long indexIdCount, /*String url,*/ String sitemapHost,
            String sitemapPath, Date submittedOn, boolean fromRobotsTxt, boolean fromUser, Date processedOn,
            Date realProcessedOn, SitemapFormatEnum sitemapFormat, SitemapTypeEnum sitemapType, Integer urlsCount,
            Integer xmlErrorsCount, Integer urlErrorsCount, Integer warningsCount,
            boolean hasChildren, SitemapSourceEnum source)
    {
        super(id, indexId, /*url,*/ sitemapHost, sitemapPath, submittedOn, fromRobotsTxt, fromUser, processedOn,
                realProcessedOn, sitemapFormat, sitemapType, urlsCount, xmlErrorsCount, urlErrorsCount, warningsCount,
                hasChildren);
        this.source = source;
        this.indexIdCount = indexIdCount;
    }

    public SitemapSourceEnum getSource() {
        return source;
    }

    public Long getIndexIdCount() {
        return indexIdCount;
    }

    public void setIndexIdCount(Long indexIdCount) {
        this.indexIdCount = indexIdCount;
    }
}
