package ru.yandex.wmconsole.data.info;

import java.util.Date;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class NotificationInfo {
    private final Long notificationId;
    private final Date happenedTime;
    private final long userId;
    private final Long issueId;
    private final Integer notificationType;

    public NotificationInfo(Long notificationId, Date happenedTime, long userId, Integer notificationType,
                            Long issueId) {
        this.userId = userId;
        this.notificationType = notificationType;
        this.issueId = issueId;
        this.notificationId = notificationId;
        this.happenedTime = happenedTime;
    }

    public Long getUserId() {
        return userId;
    }

    public Long getIssueId() {
        return issueId;
    }

    public Integer getNotificationType() {
        return notificationType;
    }

    public Long getNotificationId() {
        return notificationId;
    }

    public Date getHappenedTime() {
        return happenedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationInfo)) {
            return false;
        }

        NotificationInfo that = (NotificationInfo) o;

        if (!happenedTime.equals(that.happenedTime)) {
            return false;
        }
        if (!issueId.equals(that.issueId)) {
            return false;
        }
        if (!notificationId.equals(that.notificationId)) {
            return false;
        }
        if (!notificationType.equals(that.notificationType)) {
            return false;
        }
        if (userId != that.userId) {
            return false;
        }

        return true;
    }

    public int hashCode() {
        int result = notificationId.hashCode();
        result = 31 * result + happenedTime.hashCode();
        result = 31 * result + (int) userId;
        result = 31 * result + issueId.hashCode();
        result = 31 * result + notificationType.hashCode();
        return result;
    }

    public String toString() {
        return notificationId.toString();
    }
}
