package ru.yandex.wmconsole.data.info;

import java.util.Date;

import ru.yandex.wmconsole.data.NotificationTypeEnum;

/**
 * Internal notification message
 *
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class NotificationMessageInfo implements Comparable<NotificationMessageInfo> {
    private final Long messageId;
    private final long userId;
    private final String message;
    private final NotificationTypeEnum notificationType;
    private final Integer serviceNumber;
    private final Date receiveTime;
    private final Boolean viewed;
    private final Boolean hidden;

    public NotificationMessageInfo(Long messageId, long userId, String message, NotificationTypeEnum notificationType,
                                   Integer serviceNumber, Date receiveTime, Boolean viewed, Boolean hidden) {
        this.messageId = messageId;
        this.userId = userId;
        this.message = message;
        this.notificationType = notificationType;
        this.serviceNumber = serviceNumber;
        this.receiveTime = receiveTime;
        this.viewed = viewed;
        this.hidden = hidden;
    }

    public Long getMessageId() {
        return messageId;
    }

    public long getUserId() {
        return userId;
    }

    public String getMessage() {
        return message;
    }

    public NotificationTypeEnum getNotificationType() {
        return notificationType;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public Boolean getViewed() {
        return viewed;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public Integer getServiceNumber() {
        return serviceNumber;
    }

    @Override
    public int compareTo(NotificationMessageInfo info) {
        if (getNotificationType().getPriority() != info.getNotificationType().getPriority()) {
            return getNotificationType().getPriority() - info.getNotificationType().getPriority();
        }
        if (!info.getReceiveTime().equals(getReceiveTime())) {
            return info.getReceiveTime().compareTo(getReceiveTime());
        }
        return info.getMessageId().compareTo(getMessageId());
    }
}
