package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.NotificationTypeEnum;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class NotificationOptionInfo {
    private final Integer notificationType;
    private final NotificationChannelEnum notificationChannel;

    public NotificationOptionInfo(NotificationTypeEnum notificationType, NotificationChannelEnum notificationChannel) {
        this.notificationType = notificationType.getValue();
        this.notificationChannel = notificationChannel;
    }

    public NotificationOptionInfo(Integer foreignServiceId, NotificationChannelEnum notificationChannel) {
        this.notificationType = foreignServiceId;
        this.notificationChannel = notificationChannel;
    }

    public NotificationChannelEnum getNotificationChannel() {
        return notificationChannel;
    }

    public Integer getNotificationType() {
        return notificationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationOptionInfo)) {
            return false;
        }

        NotificationOptionInfo that = (NotificationOptionInfo) o;

        return (notificationChannel == that.notificationChannel) && (notificationType.equals(that.notificationType));
    }

    public int hashCode() {
        return 31 * notificationType.hashCode() + notificationChannel.hashCode();
    }
}
