package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.AvailableEnum;

import java.util.Date;

/**
 * User: azakharov
 * Date: 06.03.13
 * Time: 13:14
 */
public class OfflineLinksInfo {
    private final AvailableEnum available; // OPTION_DISABLED | NOT_READY | OLD | NEW
    private final String fileName;         // if available in {OLD, NEW}
    private final Long size;               // if available in {OLD, NEW}
    private final Date date;               // if available in {OLD, NEW}
    private final Boolean enabled;         // real option state
    private final Date requestDate;        // valid iff optionEnabled = true

    private static OfflineLinksInfo optionDisabled =
            new OfflineLinksInfo(AvailableEnum.OPTION_DISABLED, false, null, null, null, null);

    public OfflineLinksInfo(AvailableEnum available, Boolean enabled, Date requestDate, String fileName, Long size, Date date) {
        this.available = available;
        this.enabled = enabled;
        this.requestDate = requestDate;
        this.fileName = fileName;
        this.size = size;
        this.date = date;
    }

    public static OfflineLinksInfo createOptionDisabled() {
        return optionDisabled;
    }

    public static OfflineLinksInfo createNotReady(Boolean enabled, Date requestDate) {
        return new OfflineLinksInfo(AvailableEnum.NOT_READY, enabled, requestDate, null, null, null);
    }

    public AvailableEnum getAvailable() {
        return available;
    }

    public Date getRequestDate() {
        return requestDate;
    }

    public String getFileName() {
        return fileName;
    }

    public Long getSize() {
        return size;
    }

    public Date getDate() {
        return date;
    }

    public Boolean getEnabled() {
        return enabled;
    }
}
