package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;

import java.util.Date;

/**
 * User: azakharov
 * Date: 29.10.13
 * Time: 19:16
 */
public class PenaltyInfo {
    private HostStatusInfo hostStatusInfo;
    private Date lastAccessHtarc;
    private Date lastAccessYa;
    private Date statusDate;

    public PenaltyInfo(HostStatusInfo hostStatusInfo, Date lastAccessHtarc, Date lastAccessYa, Date statusDate) {
        this.hostStatusInfo = hostStatusInfo;
        this.lastAccessHtarc = lastAccessHtarc;
        this.lastAccessYa = lastAccessYa;
        this.statusDate = statusDate;
    }

    public HostStatusInfo getHostStatusInfo() {
        return hostStatusInfo;
    }

    public Date getLastAccessHtarc() {
        return lastAccessHtarc;
    }

    public Date getLastAccessYa() {
        return lastAccessYa;
    }

    public HostInfoStatusEnum getCalculatedStatus() {
        if (hostStatusInfo == null) {
            return null;
        }
        return hostStatusInfo.getCalculatedHostInfoStatus();
    }

    public Date getPenaltyLastAccess() {
        if (hostStatusInfo == null) {
            return null;
        }
        HostInfoStatusEnum status =  hostStatusInfo.getCalculatedHostInfoStatus();
        if (status == null || !HostInfoStatusEnum.isPenaltyStatus(status)) {
            return statusDate;
        }
        if (!HostInfoStatusEnum.isWillStatus(status)) {
            // должна быть дата с ya
            return lastAccessYa;
        } else {
            // должна быть дата с htarc
            return lastAccessHtarc != null ? lastAccessHtarc : lastAccessYa;
        }
    }

    public PenaltyInfo mergeHostStatus(HostInfoStatusEnum status, Date statusDate) {
        final HostStatusInfo oldStatus =
                hostStatusInfo != null ? hostStatusInfo : new HostStatusInfo(null, null, null, null, null, null, null);

        final HostStatusInfo newStatus = new HostStatusInfo(
                oldStatus.getHostInfoStatusHtarc(),
                oldStatus.getHostInfoStatusYa(),
                status,
                oldStatus.getPenaltyHtarc(),
                oldStatus.getPenaltyYa(),
                true,
                true);
        return new PenaltyInfo(newStatus, lastAccessHtarc, lastAccessYa, statusDate);
    }
}
