package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.LanguageEnum;
import ru.yandex.wmconsole.data.WMCHistoryObjectTypeEnum;
import ru.yandex.wmtools.common.data.IHistoryAction;
import ru.yandex.wmtools.common.data.info.WMUserInfo;

import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 15:45:34
 */
public class PersonalDraftMessageInfo extends DraftMessageInfo {
    private final long recipientsCount;
    private final WMUserInfo firstRecipient;

    public PersonalDraftMessageInfo(long messageId, WMUserInfo lastEditor, String header, String content, IHistoryAction state, Date lastAccess, WMCHistoryObjectTypeEnum type, long recipientsCount, WMUserInfo firstRecipient, LanguageEnum language) {
        super(messageId, lastEditor, header, content, state, lastAccess, type, language);
        this.recipientsCount = recipientsCount;
        this.firstRecipient = firstRecipient;
    }

    public PersonalDraftMessageInfo(DraftMessageInfo draftMessageInfo, long recipientsCount, WMUserInfo firstRecipient) {
        this(draftMessageInfo.getMessageId(),
                draftMessageInfo.getLastEditor(),
                draftMessageInfo.getHeader(),
                draftMessageInfo.getContent(),
                draftMessageInfo.getState(),
                draftMessageInfo.getLastAccess(),
                draftMessageInfo.getType(),
                recipientsCount,
                firstRecipient,
                draftMessageInfo.getLanguage());
    }

    public long getRecipientsCount() {
        return recipientsCount;
    }

    public WMUserInfo getFirstRecipient() {
        return firstRecipient;
    }
}
