package ru.yandex.wmconsole.data.info;

import java.util.Date;

import org.joda.time.DateTime;
import org.joda.time.Days;

import ru.yandex.wmconsole.data.VirusRecheckEnum;
import ru.yandex.wmconsole.data.VirusRecheckStateEnum;

/**
 * User: azakharov
 * Date: 23.01.13
 * Time: 17:22
 */
public final class RecheckInfo {
    private final VirusRecheckEnum recheck;
    private final Date date;

    public RecheckInfo(VirusRecheckEnum recheck, Date date) {
        this.recheck = recheck;
        this.date = date;
    }

    public boolean isRecheck() {
        if (VirusRecheckEnum.REQUEST.equals(recheck) ||
                VirusRecheckEnum.WAIT.equals(recheck)) {
            return true;
        } else {
            return false;
        }
    }

    public VirusRecheckStateEnum getRecheckState() {
        if (VirusRecheckEnum.REQUEST.equals(recheck) ||
                VirusRecheckEnum.WAIT.equals(recheck)) {
            if (date != null) {
                DateTime requestDate = new DateTime(date);
                DateTime warningDate = requestDate.plus(Days.THREE);
                DateTime now = new DateTime();
                if (now.isAfter(warningDate)) {
                    return VirusRecheckStateEnum.HUNG_RECHECK;
                }
            }
            return VirusRecheckStateEnum.RECHECK;
        } else {
            return VirusRecheckStateEnum.NONE;
        }
    }

    public Date getDate() {
        return date;
    }
}
