package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.HostRegionChangeRequestStateEnum;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.data.info.WMUserInfo;

import java.util.Date;

/**
 * @author baton
 */
public class RegionModerationHistoryInfo {
    private final long id;
    private final WMUserInfo moderator;
    private final long hostId;
    private final String hostname;
    private final Date performedOn;
    private final HostRegionChangeRequestStateEnum state;
    private final RegionInfo region;
    private final RegionInfo autoRegion;
    private final String url;
    private final boolean applied;

    public RegionModerationHistoryInfo(final long id, final WMUserInfo moderator, final long hostId, final String hostname,
                                       final Date performedOn, final HostRegionChangeRequestStateEnum state,
                                       final RegionInfo region, final RegionInfo autoRegion, final String url, final boolean applied) {
        this.id = id;
        this.moderator = moderator;
        this.hostId = hostId;
        this.hostname = hostname;
        this.performedOn = performedOn;
        this.state = state;
        this.region = region;
        this.autoRegion = autoRegion;
        this.url = url;
        this.applied = applied;
    }

    public long getId() {
        return id;
    }

    public WMUserInfo getModerator() {
        return moderator;
    }

    public long getHostId() {
        return hostId;
    }

    public Date getPerformedOn() {
        return performedOn;
    }

    public HostRegionChangeRequestStateEnum getState() {
        return state;
    }

    public String getHostname() {
        return hostname;
    }

    public RegionInfo getRegion() {
        return region;
    }

    public RegionInfo getAutoRegion() {
        return autoRegion;
    }

    public String getUrl() {
        return url;
    }

    public boolean isApplied() {
        return applied;
    }
}
