package ru.yandex.wmconsole.data.info;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/**
 * @author aherman
 */
public class SearchUpdateIntervalInfo {
    @NotNull
    private final DateTime startTime;

    @Nullable
    private final DateTime endTime;

    public SearchUpdateIntervalInfo(@NotNull DateTime startTime,
            @Nullable DateTime endTime)
    {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @NotNull
    public DateTime getStartTime() {
        return startTime;
    }

    @Nullable
    public DateTime getEndTime() {
        return endTime;
    }
}
