package ru.yandex.wmconsole.data.info;

import java.net.IDN;

import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * Represents a short information about host.
 *
 * @author ailyin
 */
public class ShortHostInfo implements Comparable<ShortHostInfo> {
    private static final String PROTOCOL_SIGNS = "://";
    private static final String PORT_SIGNS = ":";

    private final long id;
    private final String name;
    private final VerificationStateEnum verificationState;
    private final VerificationTypeEnum verificationType;
    private String hostMainPart;

    public ShortHostInfo(long id, String name, VerificationStateEnum verificationState,
                         VerificationTypeEnum verificationType) {
        this.id = id;
        this.name = name;
        this.verificationState = verificationState;
        this.verificationType = verificationType;

        hostMainPart = getName().toLowerCase();

        int idx = hostMainPart.indexOf(PROTOCOL_SIGNS);
        if (idx >= 0) {
            hostMainPart = hostMainPart.substring(idx + PROTOCOL_SIGNS.length());
        }

        idx = hostMainPart.indexOf(PORT_SIGNS);
        if (idx >= 0) {
            hostMainPart = hostMainPart.substring(0, idx);
        }
    }

    public long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getPunycodeName() {
        return IDN.toASCII(name).toLowerCase();
    }

    public VerificationStateEnum getVerificationState() {
        return verificationState;
    }

    public VerificationTypeEnum getVerificationType() {
        return verificationType;
    }

    private String getHostPartForSort() {
        return hostMainPart + " " + name;
    }

    @Override
    public int compareTo(ShortHostInfo o) {
        return getHostPartForSort().compareTo(o.getHostPartForSort());
    }
}
