package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.SeverityEnum;
import ru.yandex.wmconsole.data.sitemaps.SitemapErrorEnum;

/**
 * Sitemap error info.
 *
 * @author ailyin
 */
public class SitemapErrorInfo {
    private final SitemapErrorEnum error;
    private final SeverityEnum severity;
    private final Integer line;
    private final Integer position;
    private final String text;

    public SitemapErrorInfo(SitemapErrorEnum error, SeverityEnum severity, Integer line, Integer position,
            String text) {
        this.error = error;
        this.severity = severity;
        this.line = line;
        this.position = position;
        this.text = text;
    }

    public SitemapErrorEnum getError() {
        return error;
    }

    public SeverityEnum getSeverity() {
        return severity;
    }

    public Integer getLine() {
        return line;
    }

    public Integer getPosition() {
        return position;
    }

    public String getText() {
        return text;
    }
}
