package ru.yandex.wmconsole.data.info;

import java.util.Date;

import ru.yandex.wmconsole.data.sitemaps.SitemapFormatEnum;
import ru.yandex.wmconsole.data.sitemaps.SitemapTypeEnum;

/**
 * New Sitemap info.
 * Immutable and does not store information about all children.
 *
 * @author baton
 */
public class SitemapInfo {
    private final long id;
    private Long indexId;
//    private final String url;
    private final String sitemapHost;
    private final String sitemapPath;
    private final Date submittedOn;
    private final boolean fromRobotsTxt;
    private final boolean fromUser;
    private final Date proccessedOn;
    private final Date realProcessedOn;
    private final SitemapFormatEnum sitemapFormat;
    private final SitemapTypeEnum sitemapType;
    private final Integer urlsCount;
    private final Integer xmlErrorsCount;
    private final Integer urlErrorsCount;
    private final Integer warningsCount;
    private final boolean hasChildren;

    public SitemapInfo(long id, /*String url,*/ String sitemapHost, String sitemapPath, Date submittedOn, boolean fromRobotsTxt, boolean fromUser) {
        this.id = id;
//        this.url = url;
        this.sitemapHost = sitemapHost;
        this.sitemapPath = sitemapPath;
        this.submittedOn = submittedOn;
        this.fromRobotsTxt = fromRobotsTxt;
        this.fromUser = fromUser;

        this.proccessedOn = null;
        this.realProcessedOn = null;
        this.sitemapFormat = null;
        this.urlsCount = null;
        this.xmlErrorsCount = null;
        this.urlErrorsCount = null;
        this.sitemapType = null;
        this.warningsCount = 0;
        this.hasChildren = false;
        this.indexId = null;
    }

    public SitemapInfo(long id, Long indexId, /*String url,*/ String sitemapHost, String sitemapPath, Date submittedOn, boolean fromRobotsTxt, boolean fromUser,
                       Date proccessedOn, Date realProcessedOn, SitemapFormatEnum sitemapFormat,
                       SitemapTypeEnum sitemapType, Integer urlsCount, Integer xmlErrorsCount,
                       Integer urlErrorsCount, Integer warningsCount, boolean hasChildren) {
        this.id = id;
        this.indexId = indexId;
//        this.url = url;
        this.sitemapHost = sitemapHost;
        this.sitemapPath = sitemapPath;
        this.submittedOn = submittedOn;
        this.fromRobotsTxt = fromRobotsTxt;
        this.fromUser = fromUser;
        this.proccessedOn = proccessedOn;
        this.realProcessedOn = realProcessedOn;
        this.sitemapFormat = sitemapFormat;
        this.sitemapType = sitemapType;
        this.urlsCount = urlsCount;
        this.xmlErrorsCount = xmlErrorsCount;
        this.urlErrorsCount = urlErrorsCount;
        this.warningsCount = warningsCount;
        this.hasChildren = hasChildren;
    }

    public long getId() {
        return id;
    }

    public Long getIndexId() {
        return indexId;
    }

    public void setIndexId(Long indexId) {
        this.indexId = indexId;
    }

    public String getUrl() {
        return sitemapHost + sitemapPath;
    }

    public Date getSubmittedDate() {
        return submittedOn;
    }

    public boolean isFromRobotsTxt() {
        return fromRobotsTxt;
    }

    public boolean isFromUser() {
        return fromUser;
    }

    public Date getProccessedDate() {
        return proccessedOn;
    }

    public Date getRealProcessedDate() {
        return realProcessedOn;
    }

    public SitemapFormatEnum getSitemapFormat() {
        return sitemapFormat;
    }

    public SitemapTypeEnum getSitemapType() {
        return sitemapType;
    }

    public Integer getUrlsCount() {
        return urlsCount;
    }

    public Integer getXmlErrorsCount() {
        return xmlErrorsCount;
    }

    public Integer getUrlErrorsCount() {
        return urlErrorsCount;
    }

    public Integer getWarningsCount() {
        return warningsCount;
    }

    public boolean hasChildren() {
        return hasChildren;
    }

    public String getSitemapHost() {
        return sitemapHost;
    }

    public String getSitemapPath() {
        return sitemapPath;
    }
}
