package ru.yandex.wmconsole.data.info;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Информация для навигации в сервантлетах
 * User: azakharov
 * Date: 06.03.12
 * Time: 18:21
 */
@XmlRootElement(name = "sitemap-navigation")
public class SitemapNavigationInfo {
    private Long sitemapIndex;

    private String indexUrl;

    private Long sitemapId;

    private String sitemapUrl;

    private Integer source;

    public SitemapNavigationInfo() {
        // for JAXB
    }

    public SitemapNavigationInfo(Long sitemapIndex, String indexUrl, Long sitemapId, String sitemapUrl, Integer source) {
        this.sitemapIndex = sitemapIndex;
        this.indexUrl = indexUrl;

        this.sitemapId = sitemapId;
        this.sitemapUrl = sitemapUrl;

        this.source = source;
    }

    @XmlElement(name = "sitemap-index")
    public Long getSitemapIndex() {
        return sitemapIndex;
    }

    @XmlElement(name = "index-url")
    public String getIndexUrl() {
        return indexUrl;
    }

    @XmlElement(name = "sitemap-id")
    public Long getSitemapId() {
        return sitemapId;
    }

    @XmlElement(name = "url")
    public String getSitemapUrl() {
        return sitemapUrl;
    }

    @XmlElement(name = "source")
    public Integer getSource() {
        return source;
    }
}
