package ru.yandex.wmconsole.data.info;

import java.util.Date;
import java.util.Map;

import ru.yandex.wmconsole.data.Node;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 27.07.2007
 * Time: 15:11:37
 */
public class TreeInfo {
    private Node selectedNode;
    private final Node rootNode;
    private final Map<Long, Node> id2node;
    private final Date actualDate;

    public TreeInfo(Long selectedNodeId, Node rootNode, Map<Long, Node> id2node, Date actualDate) {
        this.rootNode = rootNode;
        this.id2node = id2node;
        this.actualDate = actualDate;
        setSelectedNodeId(selectedNodeId);
    }

    public Node getSelectedNode() {
        return selectedNode;
    }

    public Node getRootNode() {
        return rootNode;
    }

    public Map<Long, Node> getId2node() {
        return id2node;
    }

    public void setSelectedNodeId(Long selectedNodeId) {
        selectedNode = id2node.get(selectedNodeId);
        if (selectedNode == null) {
            selectedNode = rootNode;
        }
    }

    public Date getActualDate() {
        return actualDate;
    }
}
