package ru.yandex.wmconsole.data.info;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 22.03.2007
* Time: 21:43:03
*/
public class TreeNodeInfo {
    private final long id;
    private final Long parentId;
    private final String name; // имя элемента пути  (например, books/)
    private Long urlsInSubtree;
    private Long indexCount;
    private Long urlsTrend;
    private Long indexCountTrend;
    private int childrenCnt;
    private boolean hasIntLinks;
    private boolean hasExtLinks;
    private String path;      // полный путь (например, /shop/books/fantasy)

    public TreeNodeInfo(
            long id,
            Long parentId,
            String name,
            Long urlsInSubtree,
            Long indexCount,
            boolean hasIntLinks,
            boolean hasExtLinks,
            int childrenCnt, Long urlsTrend, Long indexCountTrend) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.urlsInSubtree = urlsInSubtree;
        this.indexCount = indexCount;
        this.childrenCnt = childrenCnt;
        this.hasIntLinks = hasIntLinks;
        this.hasExtLinks = hasExtLinks;
        this.urlsTrend = urlsTrend;
        this.indexCountTrend = indexCountTrend;
    }

    public TreeNodeInfo(TreeNodeInfo info) {
        this(info.getId(), info.getParentId(), info.getName(), info.getUrlsInSubtree(), info.getIndexCount(), info.hasIntLinks(), info.hasExtLinks(), info.getChildrenCnt(), info.getUrlsTrend(), info.getIndexCountTrend());
    }

    public long getId() {
        return id;
    }

    public Long getParentId() {
        return parentId;
    }

    public String getName() {
        return name;
    }

    public Long getUrlsInSubtree() {
        return urlsInSubtree;
    }

    public void setUrlsInSubtree(Long urlsInSubtree) {
        this.urlsInSubtree = urlsInSubtree;
    }

    public int getChildrenCnt() {
        return childrenCnt;
    }

    public boolean hasChildren() {
        return childrenCnt > 0;
    }

    public void setHasChildren(boolean hasChildren) {
        this.childrenCnt = hasChildren ? 1 : 0;
    }

    public boolean hasIntLinks() {
        return hasIntLinks;
    }

    public boolean hasExtLinks() {
        return hasExtLinks;
    }

    public Long getIndexCount() {
        return indexCount;
    }

    public void setIndexCount(Long indexCount) {
        this.indexCount = indexCount;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getUrlsTrend() {
        return urlsTrend;
    }

    public void setUrlsTrend(Long urlsTrend) {
        this.urlsTrend = urlsTrend;
    }

    public Long getIndexCountTrend() {
        return indexCountTrend;
    }

    public void setIndexCountTrend(Long indexCountTrend) {
        this.indexCountTrend = indexCountTrend;
    }
}
