package ru.yandex.wmconsole.data.info;

/**
 * Url with <code>AllowInfo</code> or with an error.
 *
 * @author ailyin
 */
public class UrlAllowInfo {
    private final String url;

    private final AllowInfo allowInfo;

    private final String error;

    public UrlAllowInfo(String url, AllowInfo allowInfo) {
        this.url = url;
        this.allowInfo = allowInfo;
        this.error = null;
    }

    public UrlAllowInfo(String url, String error) {
        this.url = url;
        this.allowInfo = null;
        this.error = error;
    }

    public AllowInfo getAllowInfo() {
        return allowInfo;
    }

    public String getUrl() {
        return url;
    }

    public String getError() {
        return error;
    }
}
