package ru.yandex.wmconsole.data.info;

import java.util.Collection;
import java.util.Date;

import ru.yandex.wmconsole.data.HostRegionChangeRequestStateEnum;
import ru.yandex.wmtools.common.data.info.HostRegionInfo;
import ru.yandex.wmtools.common.data.info.WMUserInfo;

/**
 * @author baton
 */
public class UserHostRegionInfo implements Comparable<UserHostRegionInfo> {
    private final long hostId;
    private final String hostName;
    private final long userId;
    private final HostRegionInfo userHostRegionInfo;
    private final HostRegionChangeRequestStateEnum state;
    private final Date updateDay;
    private final Date checkDay;
    private final WMUserInfo moderator;
    private final boolean confirmed;
    private final String url;
    private final String comment;
    private final Collection<HostRegionInfo> regions;

    public UserHostRegionInfo(final UserHostRegionInfo inf, Collection<HostRegionInfo> regions) {
        this.hostId = inf.hostId;
        this.hostName = inf.hostName;
        this.userId = inf.userId;
        this.userHostRegionInfo = inf.userHostRegionInfo;
        this.updateDay = inf.updateDay;
        this.state = inf.state;
        this.checkDay = inf.checkDay;
        this.moderator = inf.moderator;
        this.confirmed = inf.confirmed;
        this.url = inf.url;
        this.comment = inf.comment;
        this.regions = regions;
    }

    public UserHostRegionInfo(final long hostId, final String hostName, final long userId, final HostRegionInfo userHostRegionInfo, final HostRegionChangeRequestStateEnum state, final Date updateDay, final Date checkDay, final WMUserInfo moderator, final boolean confirmed, final String url, final String comment) {
        this.hostId = hostId;
        this.hostName = hostName;
        this.userId = userId;
        this.userHostRegionInfo = userHostRegionInfo;
        this.updateDay = updateDay;
        this.state = state;
        this.checkDay = checkDay;
        this.moderator = moderator;
        this.confirmed = confirmed;
        this.url = url;
        this.comment = comment;
        this.regions = null;
    }

    public long getHostId() {
        return hostId;
    }

    public String getHostName() {
        return hostName;
    }

    public long getUserId() {
        return userId;
    }

    public HostRegionInfo getUserClassificationInfo() {
        return userHostRegionInfo;
    }

    public Date getUpdateDay() {
        return updateDay;
    }

    public Date getCheckDay() {
        return checkDay;
    }

    public WMUserInfo getModerator() {
        return moderator;
    }

    public HostRegionChangeRequestStateEnum getState() {
        return state;
    }

    public boolean isConfirmed() {
        return confirmed;
    }

    public String getUrl() {
        return url;
    }

    public String getComment() {
        return comment;
    }

    @Override
    public int compareTo(UserHostRegionInfo o) {
        if (updateDay.before(o.updateDay)) {
            return -1;
        }
        if (updateDay.after(o.updateDay)) {
            return 1;
        }

        if (getHostId() < o.getHostId()) {
            return -1;
        }
        if (getHostId() > o.getHostId()) {
            return 1;
        }

        return Integer.compare(userHostRegionInfo.getRegionInfo().getId(), o.userHostRegionInfo.getRegionInfo().getId());
    }

    public Collection<HostRegionInfo> getRegions() {
        return regions;
    }
}
