package ru.yandex.wmconsole.data.info;

import ru.yandex.wmconsole.data.LanguageEnum;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class UserOptionsInfo {
    private final Long userId;
    private final String email;
    private final Long phone;
    private final LanguageEnum emailLanguage;
    private final Integer errorsGrow;
    private final boolean useGlobalErrorOptions;

    public UserOptionsInfo(Long userId, String email, LanguageEnum emailLanguage, Long phone, Integer errorsGrow,
                           Boolean useGlobalErrorOptions) {
        this.userId = userId;
        this.email = email;
        this.emailLanguage = emailLanguage;
        this.phone = phone;
        this.errorsGrow = errorsGrow;
        this.useGlobalErrorOptions = useGlobalErrorOptions;
    }

    public Long getUserId() {
        return userId;
    }

    public String getEmail() {
        return email;
    }

    public Long getPhone() {
        return phone;
    }

    public Integer getErrorsGrow() {
        return errorsGrow;
    }

    public LanguageEnum getEmailLanguage() {
        return emailLanguage;
    }

    public boolean isUseGlobalErrorOptions() {
        return useGlobalErrorOptions;
    }

    public UserOptionsInfo replacePercent(Integer errorsGrowPercent) {
        return new UserOptionsInfo(
                this.getUserId(),
                this.getEmail(),
                this.getEmailLanguage(),
                this.getPhone(),
                errorsGrowPercent,
                this.isUseGlobalErrorOptions()
        );
    }

    public UserOptionsInfo replaceEmailOptions(String email, LanguageEnum emailLang) {
        return new UserOptionsInfo(
                this.getUserId(),
                email != null ? email : this.getEmail(),
                emailLang != null ? emailLang : this.getEmailLanguage(),
                this.getPhone(),
                this.getErrorsGrow(),
                this.isUseGlobalErrorOptions());
    }

    public UserOptionsInfo replaceEmailLanguage(LanguageEnum newEmailLanguage) {
        return new UserOptionsInfo(
                this.getUserId(),
                this.getEmail(),
                newEmailLanguage,
                this.getPhone(),
                this.getErrorsGrow(),
                this.isUseGlobalErrorOptions());
    }

    public UserOptionsInfo replaceUseGlobalErrorOptions(boolean useGlobalErrorOptions) {
        return new UserOptionsInfo(
                this.getUserId(),
                this.getEmail(),
                this.getEmailLanguage(),
                this.getPhone(),
                this.getErrorsGrow(),
                useGlobalErrorOptions);
    }
}
