package ru.yandex.wmconsole.data.info;

import ru.yandex.common.framework.user.UserInfo;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

import java.util.Date;

/**
 * @author avhaliullin
 *         Represents info about user-host pair if host verified or user has delegation.
 */
public class UsersHostsVerificationInfo {
    private final Date verificationDate;
    private final VerificationTypeEnum verificationType;
    private final long hostId;
    private final UserInfo userGotInfo;
    private final UserInfo userGaveInfo;
    private final boolean hostAdded;
    private final boolean mayRedelegate;
    private final String verifyFaultLog;
    private final Integer httpCode;
    private final Long verificationUin;
    private final VerificationStateEnum verificationState;

    private UsersHostsVerificationInfo(long hostId, UserInfo userGotInfo, Date verificationDate, VerificationTypeEnum verificationType,
                                       VerificationStateEnum verificationState, String verifyFaultLog, Integer httpCode,
                                       Long verificationUin, UserInfo userGaveInfo,
                                       boolean hostAdded,
                                       boolean mayRedelegate) {
        this.verificationDate = verificationDate;
        this.verificationType = verificationType;
        this.hostId = hostId;
        this.userGotInfo = userGotInfo;
        this.verificationState = verificationState;
        this.verificationUin = verificationUin;
        this.userGaveInfo = userGaveInfo;
        this.hostAdded = hostAdded;
        this.mayRedelegate = mayRedelegate;
        this.verifyFaultLog = verifyFaultLog;
        this.httpCode = httpCode;
    }

    public UsersHostsVerificationInfo(UsersHostsInfo usersHostsInfo) {
        this(usersHostsInfo.getHostId(), usersHostsInfo.getUserInfo(), usersHostsInfo.getVerificationDate(), usersHostsInfo.getVerificationType(),
                usersHostsInfo.getVerificationState(), usersHostsInfo.getVerifyFaultLog(), usersHostsInfo.getHttpCode(), usersHostsInfo.getVerificationUin(), null, true, true);
    }

    public UsersHostsVerificationInfo(UsersHostsInfo usersHostsInfo, DelegationInfo delegationInfo, UserInfo userGaveInfo) {
        this(usersHostsInfo.getHostId(), usersHostsInfo.getUserInfo(), usersHostsInfo.getVerificationDate(), usersHostsInfo.getVerificationType(),
                usersHostsInfo.getVerificationState(), usersHostsInfo.getVerifyFaultLog(), usersHostsInfo.getHttpCode(), usersHostsInfo.getVerificationUin(), userGaveInfo, true, delegationInfo.isMayRedelegate());
    }

    public UsersHostsVerificationInfo(DelegationInfo delegationInfo, UserInfo userGaveInfo) {
        this(delegationInfo.getHostId(), delegationInfo.getUserGotInfo(), delegationInfo.getDelegationDate(), VerificationTypeEnum.DELEGATION,
                null, null, null, null, userGaveInfo, false, delegationInfo.isMayRedelegate());
    }

    public Date getVerificationDate() {
        return verificationDate;
    }

    public VerificationTypeEnum getVerificationType() {
        return verificationType;
    }

    public long getHostId() {
        return hostId;
    }

    public UserInfo getUserGotInfo() {
        return userGotInfo;
    }

    public UserInfo getUserGaveInfo() {
        return userGaveInfo;
    }

    public boolean isHostAdded() {
        return hostAdded;
    }

    public boolean isMayRedelegate() {
        return mayRedelegate;
    }

    public String getVerifyFaultLog() {
        return verifyFaultLog;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public Long getVerificationUin() {
        return verificationUin;
    }

    public long getUserId() {
        return getUserGotInfo().getUserId();
    }

    public VerificationStateEnum getVerificationState() {
        return verificationState;
    }
}
