package ru.yandex.wmconsole.data.info;

import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;

import java.net.URL;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class XMLSerpLinkInfo {
    private final String name;
    private final String url;

    public XMLSerpLinkInfo(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return name;
    }

    public String getUrl() {
        return url;
    }

    public static String getSectionName(String hostName, String path) throws UserException {
        if (path == null) {
            path = "/";
        }
        String sectionUrl = hostName + path;
        //asserting url is valid
        AbstractServantlet.prepareUrl(sectionUrl, false);
        if (sectionUrl.endsWith("/")) {
            sectionUrl = sectionUrl.substring(0, sectionUrl.length() - 1);
        }
        return sectionUrl;
    }
}
