package ru.yandex.wmconsole.data.info;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * User: azakharov
 * Date: 12.04.12
 * Time: 13:10
 */
@XmlRootElement(name = "host")
public class XmlSearchFastHostInfo {
    private Long userId;
    private Long hostId;
    private Long indexCount;
    private Long urls;
    private Long tcy;
    private Boolean showIndexInfo;
    private Exception exception;

    public XmlSearchFastHostInfo() {
        // for JAXB
    }

    public XmlSearchFastHostInfo(Long userId, Long hostId, Long indexCount, Long urls, Long tcy, Boolean showIndexInfo) {
        this.userId = userId;
        this.hostId = hostId;
        this.indexCount = indexCount;
        this.urls = urls;
        this.tcy = tcy;
        this.showIndexInfo = showIndexInfo;
    }

    public XmlSearchFastHostInfo(Long hostId, Exception exception) {
        this.hostId = hostId;
        this.exception = exception;
    }

    @XmlAttribute(name = "id", required = true)
    public Long getHostId() {
        return hostId;
    }

    public void setHostId(Long hostId) {
        this.hostId = hostId;
    }

    @XmlElement(name = "index-count")
    public Long getIndexCount() {
        return indexCount;
    }

    public void setIndexCount(Long indexCount) {
        this.indexCount = indexCount;
    }

    @XmlElement(name = "urls")
    public Long getUrls() {
        return urls;
    }

    public void setUrls(Long urls) {
        this.urls = urls;
    }

    @XmlElement(name = "tcy")
    public Long getTcy() {
        return tcy;
    }

    public void setTcy(Long tcy) {
        this.tcy = tcy;
    }

    @XmlElement(name = "show-index-info")
    public Boolean getShowIndexInfo() {
        return showIndexInfo;
    }

    public void setShowIndexInfo(Boolean showIndexInfo) {
        this.showIndexInfo = showIndexInfo;
    }

    @XmlTransient
    public Exception getException() {
        return exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @XmlElement(name = "exception")
    public Boolean getWasException() {
        return (this.exception != null) ? true : null;
    }

    @XmlTransient
    public Long getUserId() {
        return userId;
    }
}
