package ru.yandex.wmconsole.data.info.all.about.url;

import java.util.Date;

/**
 * Информация из таблицы tbl_all_about_url_prodNNN или tbl_all_about_url_curNNN
 *
 * User: azakharov
 * Date: 11.03.13
 * Time: 19:11
 */
public class DbPartialUrlInfo {
    private final Date lastAccess;
    private final Integer httpCode;
    private final String searchBaseMainUrl;
    private final String redirTarget;
    private final String relCanonicalTarget;
    private final UrlIndexStatusEnum indexStatus;
    private final Boolean isSearchable;
    private final UrlNoUploadReasonEnum noUploadReason;
    private final Boolean uploadRankValues;
    private final Long links;
    private final Long internalLinks;

    public DbPartialUrlInfo(Date lastAccess,
                            Integer httpCode,
                            String searchBaseMainUrl,
                            String redirTarget,
                            String relCanonicalTarget,
                            UrlIndexStatusEnum indexStatus,
                            Boolean searchable,
                            UrlNoUploadReasonEnum noUploadReason,
                            Boolean uploadRankValues,
                            Long links,
                            Long internalLinks) {

        this.lastAccess = lastAccess;
        this.httpCode = httpCode;
        this.searchBaseMainUrl = searchBaseMainUrl;
        this.redirTarget = redirTarget;
        this.relCanonicalTarget = relCanonicalTarget;
        this.indexStatus = indexStatus;
        this.isSearchable = searchable;
        this.noUploadReason = noUploadReason;
        this.uploadRankValues = uploadRankValues;
        this.links = links;
        this.internalLinks = internalLinks;
    }

    public Date getLastAccess() {
        return lastAccess;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public String getSearchBaseMainUrl() {
        return searchBaseMainUrl;
    }

    public String getRedirTarget() {
        return redirTarget;
    }

    public String getRelCanonicalTarget() {
        return relCanonicalTarget;
    }

    public UrlIndexStatusEnum getIndexStatus() {
        return indexStatus;
    }

    public Boolean getSearchable() {
        return isSearchable != null ? isSearchable : false;
    }

    public UrlNoUploadReasonEnum getNoUploadReason() {
        return noUploadReason;
    }

    public Long getLinks() {
        return links;
    }

    public Long getInternalLinks() {
        return internalLinks;
    }

    public Boolean getUploadRankValues() {
        return uploadRankValues;
    }
}
