package ru.yandex.wmconsole.data.info.all.about.url;

import ru.yandex.webmaster.common.urltree.YandexSearchShard;
import ru.yandex.wmconsole.data.HostInfoStatusEnum;

import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * User: azakharov
 * Date: 11.03.13
 * Time: 19:24
 */
public class DbUrlInfo {
    private final Long reportId;
    private final String url;
    private final String normalizedUrl;
    private final UrlInfoStatusEnum urlProcessingStatus;
    private final Date createDate;
    private final DbPartialUrlInfo prodUrlInfo;
    private final DbPartialUrlInfo curUrlInfo;
    private final DbPartialUrlInfo htarcUrlInfo;
    private final long relCanonicalTargetsCount;
    private Boolean isFromFastRobot;
    private HostInfoStatusEnum hostInfoStatus;
    private Date penaltyLastAccess;
    private YandexSearchShard searchShard;
    private Boolean isSearchableFromXmlSearch;
    private Long linksCount;
    private Long internalLinksCount;
    private List<String> relCanonicalTargetUrls;

    public DbUrlInfo(Long reportId, String url, String normalizedUrl, UrlInfoStatusEnum urlProcessingStatus, Date createDate,
                     Boolean isFromFastRobot, HostInfoStatusEnum hostInfoStatus, Date penaltyLastAccess,
                     long relCanonicalTargetsCount,
                     DbPartialUrlInfo prodUrlInfo, DbPartialUrlInfo curUrlInfo, DbPartialUrlInfo htarcUrlInfo,
                     YandexSearchShard searchShard,
                     Boolean isSearchableFromXmlSearch, Long linksCount, Long internalLinksCount) {
        this.reportId = reportId;
        this.url = url;
        this.normalizedUrl = normalizedUrl;
        this.urlProcessingStatus = urlProcessingStatus;
        this.createDate = createDate;
        this.prodUrlInfo = prodUrlInfo;
        this.curUrlInfo = curUrlInfo;
        this.htarcUrlInfo = htarcUrlInfo;
        this.isFromFastRobot = isFromFastRobot;
        this.hostInfoStatus = hostInfoStatus;
        this.penaltyLastAccess = penaltyLastAccess;
        this.searchShard = searchShard;
        this.isSearchableFromXmlSearch = isSearchableFromXmlSearch;
        this.relCanonicalTargetsCount = relCanonicalTargetsCount;
        this.linksCount = linksCount;
        this.internalLinksCount = internalLinksCount;
        this.relCanonicalTargetUrls = Collections.emptyList();
    }

    public Long getReportId() {
        return reportId;
    }

    public String getUrl() {
        return url;
    }

    public String getNormalizedUrl() {
        return normalizedUrl;
    }

    public UrlInfoStatusEnum getUrlProcessingStatus() {
        return urlProcessingStatus;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public DbPartialUrlInfo getCurUrlInfo() {
        return curUrlInfo;
    }

    public DbPartialUrlInfo getProdUrlInfo() {
        return prodUrlInfo;
    }

    public DbPartialUrlInfo getHtarcUrlInfo() {
        return htarcUrlInfo;
    }

    public Boolean getFromFastRobot() {
        return isFromFastRobot;
    }

    public void setFromFastRobot(Boolean fromFastRobot) {
        isFromFastRobot = fromFastRobot;
    }

    public HostInfoStatusEnum getHostInfoStatus() {
        return hostInfoStatus;
    }

    public void setHostInfoStatus(HostInfoStatusEnum hostInfoStatus) {
        this.hostInfoStatus = hostInfoStatus;
    }

    public Date getPenaltyLastAccess() {
        return penaltyLastAccess;
    }

    public void setPenaltyLastAccess(Date penaltyLastAccess) {
        this.penaltyLastAccess = penaltyLastAccess;
    }

    public void setSearchableFromXmlSearch(Boolean searchableFromXmlSearch) {
        isSearchableFromXmlSearch = searchableFromXmlSearch;
    }

    public Boolean getSearchableFromXmlSearch() {
        return isSearchableFromXmlSearch;
    }

    public Long getLinksCount() {
        return linksCount;
    }

    public Long getInternalLinksCount() {
        return internalLinksCount;
    }

    public long getRelCanonicalTargetsCount() {
        return relCanonicalTargetsCount;
    }

    public List<String> getRelCanonicalTargetUrls() {
        return relCanonicalTargetUrls;
    }

    public void setRelCanonicalTargetUrls(List<String> relCanonicalTargetUrls) {
        this.relCanonicalTargetUrls = relCanonicalTargetUrls;
    }

    public YandexSearchShard getSearchShard() {
        return searchShard;
    }
}
