package ru.yandex.wmconsole.data.info.all.about.url;

/**
 * User: azakharov
 * Date: 11.02.13
 * Time: 12:33
 */

import org.jetbrains.annotations.NotNull;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.Date;

/**
 * Информация об урле в списке урлов
 */
public class ShortUrlInfo {
    private UrlRequestId requestId;    // номер заявки
    private long id;                   //
    private String url;                // запрашиваемый url
    private String normalizedUrl;      // нормализованный url
    private Date createDate;           // дата создания заявки
    private UrlInfoStatusEnum status;  // статус обработки заявки
    private Boolean selected;          // выбрана ли данная заявка или отчёт

    public ShortUrlInfo() {
        // for JAXB
    }

    /**
     * Use factory method instead
     *
     * @param requestId
     * @param url
     * @param createDate
     * @param status
     */
    protected ShortUrlInfo(@NotNull UrlRequestId requestId, String url, String normalizedUrl, Date createDate, UrlInfoStatusEnum status) {
        this.requestId = requestId;
        this.id = requestId.getId();
        this.url = url;
        this.normalizedUrl = normalizedUrl;
        this.createDate = createDate;
        this.status = status;
        this.selected = null;
    }

    @XmlTransient
    public UrlRequestId getRequestId() {
        return requestId;
    }

    @XmlElement(name = "num")
    public long getId() {
        return id;
    }

    @XmlElement(name = "url")
    public String getUrl() {
        return url;
    }

    @XmlElement(name = "normalized-url")
    public String getNormalizedUrl() {
        return normalizedUrl;
    }

    @XmlElement(name = "create-date")
    public Date getCreateDate() {
        return createDate;
    }

    @XmlElement(name = "status")
    public UrlInfoStatusEnum getStatus() {
        return status;
    }

    @XmlAttribute(name = "selected")
    public Boolean getSelected() {
        return selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public static ShortUrlInfo createUrlInfoFromQueue(
            @NotNull final UrlRequestId requestId, final String url, final Date createDate) {
        return new ShortUrlInfo(requestId, url, null, createDate, UrlInfoStatusEnum.PROCESSING);
    }

    public static ShortUrlInfo createUrlInfoFromResults(
            @NotNull final UrlRequestId requestId, final String url, final String normalizedUrl, final Date createDate,
            final boolean isError, final Date xmlSearchDataUpdateTime, final Date penaltyUpdateTime) {
        final UrlInfoStatusEnum status = UrlInfoStatusEnum.getStatusByFlags(isError, xmlSearchDataUpdateTime, penaltyUpdateTime);
        return new ShortUrlInfo(requestId, url, normalizedUrl, createDate, status);
    }
}
