package ru.yandex.wmconsole.data.info.all.about.url;

import org.jetbrains.annotations.Nullable;

/**
 * User: azakharov
 * Date: 11.03.13
 * Time: 19:13
 */
public enum UrlIndexStatusEnum {
    NEW(0),
    DELETED(2),
    INDEXED(3),
    SEMIDUP(8),
    FAKE(9);

    private int code;

    private UrlIndexStatusEnum(int code) {
        this.code = code;
    }

    public static UrlIndexStatusEnum getByCode(@Nullable Integer code) {
        if (code == null) {
            return null;
        }

        for (UrlIndexStatusEnum indexStatus : values()) {
            if (indexStatus.code == code) {
                return indexStatus;
            }
        }
        return null;
    }
}
