package ru.yandex.wmconsole.data.info.all.about.url;

import ru.yandex.webmaster.common.urltree.YandexSearchShard;
import ru.yandex.wmconsole.data.HostInfoStatusEnum;

import java.util.Date;
import java.util.List;

/**
 * Вся информация о странице URL (инструмент всё о странице)
 *
 * User: azakharov
 * Date: 11.03.13
 * Time: 17:03
 */
public class UrlInfo {
    private final Long reportId;
    private final String url;
    private final String normalizedUrl;
    private final Date createDate;

    private final UrlStatusEnum status;

    // Обход роботом
    private final Integer curHttpCode;
    private final Date curLastAccess;
    private final HostInfoStatusEnum hostInfoStatus;
    private final Date penaltyLastAccess;

    // Индексирование сайта
    private final Date lastAccess;
    private final Integer httpCode;
    private final Long linksCount;
    private final Long internalLinksCount;
    private final Boolean isFromFastRobot;
    private final YandexSearchShard searchShard;

    private final Integer htarcHttpCode;
    private final Date htarcLastAccess;

    // Пояснение к кодам и статусам
    private final String canonicalUrl;
    private final String redirTarget;
    private final List<String> relCanonicalTargetUrls;

    public UrlInfo(
            Long reportId,
            String url,
            String normalizedUrl,
            Date createDate,
            UrlStatusEnum status,
            Integer curHttpCode,
            Date curLastAccess,
            Integer httpCode,
            Date lastAccess,
            Integer htarcHttpCode,
            Date htarcLastAccess,
            Long linksCount,
            Long internalLinksCount,
            YandexSearchShard searchShard,
            String canonicalUrl,
            String redirTarget,
            List<String> relCanonicalTargetUrls,
            Boolean isFromFastRobot,
            HostInfoStatusEnum hostInfoStatus,
            Date penaltyLastAccess) {

        this.reportId = reportId;
        this.url = url;
        this.normalizedUrl = normalizedUrl;
        this.createDate = createDate;
        this.status = status;

        this.curHttpCode = curHttpCode;
        this.curLastAccess = curLastAccess;
        this.hostInfoStatus = hostInfoStatus;
        this.penaltyLastAccess = penaltyLastAccess;

        this.lastAccess = lastAccess;
        this.httpCode = httpCode;
        this.linksCount = linksCount;
        this.internalLinksCount = internalLinksCount;
        this.isFromFastRobot = isFromFastRobot;
        this.searchShard = searchShard;

        this.htarcHttpCode = htarcHttpCode;
        this.htarcLastAccess = htarcLastAccess;

        this.canonicalUrl = canonicalUrl;
        this.redirTarget = redirTarget;
        this.relCanonicalTargetUrls = relCanonicalTargetUrls;
    }

    public Long getReportId() {
        return reportId;
    }

    public String getUrl() {
        return url;
    }

    public String getNormalizedUrl() {
        return normalizedUrl;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public UrlStatusEnum getStatus() {
        return status;
    }

    public Integer getCurHttpCode() {
        return curHttpCode;
    }

    public Date getCurLastAccess() {
        return curLastAccess;
    }

    public Date getLastAccess() {
        return lastAccess;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public Long getLinksCount() {
        return linksCount;
    }

    public Long getInternalLinksCount() {
        return internalLinksCount;
    }

    public String getCanonicalUrl() {
        return canonicalUrl;
    }

    public String getRedirTarget() {
        return redirTarget;
    }

    public Boolean getFromFastRobot() {
        return isFromFastRobot;
    }

    public HostInfoStatusEnum getHostInfoStatus() {
        return hostInfoStatus;
    }

    public Date getPenaltyLastAccess() {
        return penaltyLastAccess;
    }

    public List<String> getRelCanonicalTargetUrls() {
        return relCanonicalTargetUrls;
    }

    public Integer getHtarcHttpCode() {
        return htarcHttpCode;
    }

    public Date getHtarcLastAccess() {
        return htarcLastAccess;
    }

    public YandexSearchShard getSearchShard() {
        return searchShard;
    }
}
