package ru.yandex.wmconsole.data.info.all.about.url;

import org.joda.time.DateTime;
import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.webmaster.common.util.xml.SimpleXmlBuilder;

/**
 * @author aherman
 */
public class UrlInfoXml implements XmlConvertable {
    private final UrlInfo urlInfo;

    public UrlInfoXml(UrlInfo urlInfo) {
        this.urlInfo = urlInfo;
    }

    @Override
    public void toXml(StringBuilder storage) {
        SimpleXmlBuilder xml = new SimpleXmlBuilder(storage);
        xml.open("url-info");
        xml.element("report-id", urlInfo.getReportId());
        xml.element("url", urlInfo.getUrl());
        xml.element("normalized-url", urlInfo.getNormalizedUrl());
        xml.element("create-date", urlInfo.getCreateDate());
        xml.element("status", urlInfo.getStatus());
        xml.element("cur-http-code", urlInfo.getCurHttpCode());
        xml.element("cur-last-access", urlInfo.getCurLastAccess());
        xml.element("last-access", urlInfo.getLastAccess());
        xml.element("http-code", urlInfo.getHttpCode());
        xml.element("links-count", urlInfo.getLinksCount());
        xml.element("internal-links-count", urlInfo.getInternalLinksCount());
        xml.element("search-shard", urlInfo.getSearchShard().toString());
        xml.element("canonical-url", urlInfo.getCanonicalUrl());
        xml.element("redir-target", urlInfo.getRedirTarget());

        xml.element("htarc-http-code", urlInfo.getHtarcHttpCode());
        if (urlInfo.getHtarcLastAccess() != null) {
            DateTime htarcLastAccess = new DateTime(urlInfo.getHtarcLastAccess());
            if (htarcLastAccess.getYear() > 1970) {
                xml.element("htarc-last-access", urlInfo.getHtarcLastAccess());
            }
        }

        xml.open("rel-canonical-targets");
        for (String s : urlInfo.getRelCanonicalTargetUrls()) {
            xml.element("url", s);
        }
        xml.close();

        xml.element("from-fast-robot", urlInfo.getFromFastRobot());
        xml.element("host-info-status", urlInfo.getHostInfoStatus());
        xml.element("penalty-last-access", urlInfo.getPenaltyLastAccess());
        xml.close(); // url-info
    }
}
