package ru.yandex.wmconsole.data.info.all.about.url;

import org.jetbrains.annotations.Nullable;

/**
 * User: azakharov
 * Date: 11.03.13
 * Time: 19:17
 */
public enum UrlNoUploadReasonEnum {
    OK(0),
    SR(1),
    DUP_DOC(2),
    SPAM_DOC(3);

    private int code;

    private UrlNoUploadReasonEnum(int code) {
        this.code = code;
    }

    public static UrlNoUploadReasonEnum getByCode(@Nullable Integer code) {
        if (code == null) {
            return null;
        }

        for (UrlNoUploadReasonEnum reason : values()) {
            if (reason.getCode() == code) {
                return reason;
            }
        }

        return null;
    }

    public int getCode() {
        return code;
    }
}
