package ru.yandex.wmconsole.data.info.all.about.url;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.webmaster.common.urltree.YandexSearchShard;

import java.util.Date;

/**
 * User: azakharov
 * Date: 19.11.13
 * Time: 19:59
 */
public class UrlResultInfo extends ShortUrlInfo {
    private final Long hostId;
    private Boolean searchableInFastRobot;
    private Boolean searchableXml;
    private final Long linksCountXml;
    private final Long internalLinksCountXml;
    private final Date xmlsearchDataUpdateTime;
    private final YandexSearchShard searchShard;
    private final Date penaltyLastAccess;
    private final boolean fromSupport;

    public UrlResultInfo(long hostId, @NotNull UrlRequestId requestId, String url, String normalizedUrl, Date createDate, UrlInfoStatusEnum status,
                         Boolean searchableInFastRobot, Boolean searchableXml,
                         Long linksCountXml, Long internalLinksCountXml,
                         Date xmlsearchDataUpdateTime,
                         @Nullable YandexSearchShard searchShard,
                         Date penaltyLastAccess, boolean fromSupport) {
        super(requestId, url, normalizedUrl, createDate, status);
        this.hostId = hostId;
        this.searchableInFastRobot = searchableInFastRobot;
        this.searchableXml = searchableXml;
        this.linksCountXml = linksCountXml;
        this.internalLinksCountXml = internalLinksCountXml;
        this.xmlsearchDataUpdateTime = xmlsearchDataUpdateTime;
        this.searchShard = searchShard;
        this.penaltyLastAccess = penaltyLastAccess;
        this.fromSupport = fromSupport;
    }

    public Long getHostId() {
        return hostId;
    }

    public Boolean getSearchableInFastRobot() {
        return searchableInFastRobot;
    }

    public Boolean getSearchableXml() {
        return searchableXml;
    }

    public Long getLinksCountXml() {
        return linksCountXml;
    }

    public Long getInternalLinksCountXml() {
        return internalLinksCountXml;
    }

    public void setSearchableInFastRobot(Boolean searchableInFastRobot) {

        this.searchableInFastRobot = searchableInFastRobot;
    }

    public void setSearchableXml(Boolean searchableXml) {
        this.searchableXml = searchableXml;
    }

    public String safeGetNormalizedUrl() {
        return getNormalizedUrl() != null ? getNormalizedUrl() : getUrl();
    }

    /**
     * Update time for all the db columns which data is obtained from xmlsearch.
     *
     * @return  update time
     */
    public Date getXmlsearchDataUpdateTime() {
        return xmlsearchDataUpdateTime;
    }

    public Date getPenaltyLastAccess() {
        return penaltyLastAccess;
    }

    public boolean isFromSupport() {
        return fromSupport;
    }

    public @Nullable YandexSearchShard getSearchShard() {
        return searchShard;
    }
}
