package ru.yandex.wmconsole.data.info.all.about.url;

/**
 * User: azakharov
 * Date: 11.03.13
 * Time: 17:10
 */
public enum UrlStatusEnum {
    /**
     * В поиске
     */
    SEARCHABLE_PROD,

    /**
     * В поиске урл, который выполняет редирект; содержимое берется из цели редиректа
     */
    SEARCHABLE_REDIRECT_PROD,

    /**
     * В поиске урл, который выполняет refresh; содержимое берется из цели редиректа
     */
    SEARCHABLE_REFRESH_PROD,

    /**
     * Страница есть в поиске но без документа (отсутствуют сохранённая копия, сниппеты).
     * Соответствует статусу FAKE.
     */
    SEARCHABLE_FAKE_PROD,

    /**
     * На htarc status FAKE, по данным XML-поиска страница в поиске
     */
    SEARCHABLE_FAKE_HTARC,

    /**
     * Есть данные на htarc и по данным XML-поиска страница в поике
     */
    SEARCHABLE_HTARC,

    /**
     * Страница в поиске под другим именем, но не редирект и не рефреш.
     * Статус из разряда "на всякий случай".
     */
    SEARCHABLE_DUPLICATE_PROD,

    /**
     * Страница в поиске под другим именем, но не редирект и не рефреш.
     * Различие между запрашиваемым URL и URL в поиске только в слеше.
     */
    SEARCHABLE_DUPLICATE_SLASH,

    /**
     * Ошибка на стороне сервера или сайта.
     *
     * В киви httpCode из {4xx,5xx,1003...}
     */
    SITE_ERROR_PROD,

    /**
     * Ошибка на стороне сервера или сайта.
     *
     * На хтарке httpCode из {4xx,5xx,1003...}
     */
    SITE_ERROR_HTARC,

    /**
     * В поиске главный дубль.
     *
     * Indexed (Duplicate), Semidup (у нее есть главный дубль)
     */
    DUPLICATE_PROD,

    /**
     * Cтраница не в поиске из-за низкого selection rank
     */
    SELECTION_RANK,

    /**
     * Страница из цепочки редиректов. Проиндексирована цель редиректа под более короким именем.
     * Вычисляется по http-коду с htarc.
     */
    REDIRECT_HTARC,

    /**
     * Страница из цепочки редиректов. Проиндексирована цель редиректа под более короким именем.
     * Вычисляется по http-коду из киви.
     */
    REDIRECT_PROD,

    /**
     * Страница индексируется по адресу canonical url. На странице указан <link rel="canonical"/>
     */
    NOT_CANONICAL,

    /**
     * Страница индексируется по адресу canonical url. На странице указан <link rel="canonical"/>
     * Статус строится по данным с htarc.
     */
    NOT_CANONICAL_HTARC,

    /**
     * Страница индексируется по адресу canonical url. На странице указан <link rel="canonical"/>
     * Есть данные в киви и нет данных на htarc.
     */
    NOT_CANONICAL_PROD,

    REFRESH_HTARC,

    REFRESH_PROD,

    /**
     * Страница не выкладывалась на поиск из-за антиспама или наличия полудубля.
     */
    SEMIDUP_OR_ANTISPAM,

    /**
     * Страница еще не была проиндексирована.
     *
     * Отсутствует в базе или NEW.
     */
    NEW_NOT_CRAWLED,

    NOT_CRAWLED,

    NOT_CRAWLED_SITE_ERROR,

    CLEAN_PARAMS;
}
