package ru.yandex.wmconsole.data.info.api;

import java.util.Date;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * @author ailyin
 */
public class ApiExtendedHostInfo extends ApiHostInfo {
    private final Long urlErrors;
    private final Long internalLinksCount;
    private final Long linksCount;

    public ApiExtendedHostInfo(long id, String name, VerificationStateEnum verificationState,
                               VerificationTypeEnum verificationType, Long urls, Boolean isVirused, Integer tcy,
                               Long indexCount, HostInfoStatusEnum hostInfoStatus, Date lastAccess,
                               Long urlErrors, Long internalLinksCount, Long linksCount) {
        super(id, name, verificationState, verificationType, urls, isVirused, tcy, indexCount, hostInfoStatus, lastAccess);
        this.urlErrors = urlErrors;
        this.internalLinksCount = internalLinksCount;
        this.linksCount = linksCount;
    }

    public Long getUrlErrors() {
        return urlErrors;
    }

    public Long getInternalLinksCount() {
        return internalLinksCount;
    }

    public Long getLinksCount() {
        return linksCount;
    }
}
