package ru.yandex.wmconsole.data.info.api;

import java.util.Date;

import ru.yandex.wmconsole.data.HostInfoStatusEnum;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.data.info.ShortHostInfo;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * @author ailyin
 */
public class ApiHostInfo extends ShortHostInfo {
    private final Long urls;
    private final Boolean isVirused;
    private final Integer tcy;
    private final Long indexCount;
    private final HostInfoStatusEnum hostInfoStatus;
    private final Date lastAccess;

    public ApiHostInfo(long id, String name, VerificationStateEnum verificationState,
                       VerificationTypeEnum verificationType, Long urls, Boolean isVirused, Integer tcy,
                       Long indexCount, HostInfoStatusEnum hostInfoStatus, Date lastAccess) {
        super(id, name, verificationState, verificationType);
        this.urls = urls;
        this.isVirused = isVirused;
        this.tcy = tcy;
        this.indexCount = indexCount;
        this.hostInfoStatus =  hostInfoStatus;
        this.lastAccess = lastAccess;
    }

    public Long getUrls() {
        return urls;
    }

    public Boolean isVirused() {
        return isVirused;
    }

    public Integer getTcy() {
        return tcy;
    }

    public Long getIndexCount() {
        return indexCount;
    }

    public HostInfoStatusEnum getHostInfoStatus() {
        return hostInfoStatus;
    }

    public Date getLastAccess() {
        return lastAccess;
    }
}
