package ru.yandex.wmconsole.data.info.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author yakushev
 */
public class Graph {
    private final List<GraphParam> params;
    private final List<GraphDay> days;
    private final List<GraphSystem> systems;

    public Graph() {
        days = new ArrayList<GraphDay>();
        systems = new ArrayList<GraphSystem>();

        params = new ArrayList<GraphParam>();
    }

    public void addParam(GraphParam param) {
        if (param == null) {
            throw new IllegalArgumentException("param");
        }
        params.add(param);
    }

    public void addParam(String name, String value) {
        addParam(new GraphParam(name, value));
    }

    public List<GraphParam> getParams() {
        return Collections.unmodifiableList(params);
    }

    public void addDay(GraphDay day) {
        days.add(day);
    }

    public List<GraphDay> getDays() {
        return Collections.unmodifiableList(days);
    }

    public void addSystem(GraphSystem system) {
        systems.add(system);
    }

    public List<GraphSystem> getSystems() {
        return Collections.unmodifiableList(systems);
    }
}
