package ru.yandex.wmconsole.data.info.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author yakushev
 */
public class GraphDay {
    private final Date date;

    private final List<GraphPoint> points;

    public GraphDay(Date date) {
        this(date, Collections.<GraphPoint>emptyList());
    }

    public GraphDay(Date date, List<GraphPoint> points) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        this.date = date;

        this.points = new ArrayList<GraphPoint>(points);
    }

    public void addPoint(GraphPoint point) {
        if (point == null) {
            throw new NullPointerException("point");
        }
        points.add(point);
    }

    public Date getDate() {
        return date;
    }

    public List<GraphPoint> getPoints() {
        return Collections.unmodifiableList(points);
    }
}
