package ru.yandex.wmconsole.data.info.graph;

import org.apache.commons.lang.StringUtils;

/**
 * @author yakushev
*/
public class GraphSystem {
    private final String name;
    private final boolean selected;
    private final String color;

    /**
     * @param name name of the graph system
     * @param selected is this system selected
     * @param color color which will be used in the presentation of that graph system.
     * String format same as in the java.awt.Color.
     * If <code>StringUtils.isEmpty(color)</code> then will be used color from system palette
     */
    public GraphSystem(String name, boolean selected, String color) {
        if (!StringUtils.isEmpty(color) && !checkValidColor(color)) {
            throw new IllegalArgumentException("Illegal color format. Color=" + color);
        }

        this.name = name;
        this.selected = selected;
        this.color = color;
    }

    public GraphSystem(String name, boolean selected) {
        this (
                name,
                selected,
                ""
        );
    }

    public String getName() {
        return name;
    }

    public boolean isSelected() {
        return selected;
    }

    public String getColor() {
        return color;
    }

    private boolean checkValidColor(String color) {
        if (color.charAt(0) != '#') {
            return false;
        }

        try {
            Integer.parseInt(color.substring(1), 16);
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }
}
