package ru.yandex.wmconsole.data.info.notification;

import java.util.Date;

public class MainMirrorNotificationInfo {
    private final long notificationId;
    private final long issueId;
    private final String oldHost;
    private final String newHost;
    private final Date receiveTime;

    public MainMirrorNotificationInfo(long notificationId, long issueId, String oldHost, String newHost, Date time) {
        this.notificationId = notificationId;
        this.issueId = issueId;
        this.oldHost = oldHost;
        this.newHost = newHost;
        this.receiveTime = time;
    }

    public long getIssueId() {
        return issueId;
    }

    public String getOldHost() {
        return oldHost;
    }

    public String getNewHost() {
        return newHost;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public String toString() {
        return "[Main mirror change issue id=" + issueId + " from=" + oldHost + " to=" + newHost +
                " on " + receiveTime + "]";
    }

    public long getNotificationId() {
        return notificationId;
    }
}
