package ru.yandex.wmconsole.data.info.spider;

import java.util.List;
import java.util.Set;

/**
 * @author avhaliullin
 */
public abstract class SpiderCodesGroupFactory {
    public SpiderCodesGroupInfo createGroup(Set<String> requestedSubgroups) {
        List<SpiderCodesSubgroupInfo> subgroups = getSubgroups(requestedSubgroups);
        if (subgroups.isEmpty()) {
            return null;
        }
        return new SpiderCodesGroupInfo(getGroupName(), subgroups);
    }

    protected abstract List<SpiderCodesSubgroupInfo> getSubgroups(Set<String> requestedSubgroups);

    protected abstract String getGroupName();
}
