package ru.yandex.wmconsole.data.info.spider;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SpiderCodesGroupInfo implements CodesGroup {
    private final String name;
    private final List<SpiderCodesSubgroupInfo> subgroups;

    public SpiderCodesGroupInfo(String name, List<SpiderCodesSubgroupInfo> subgroups) {
        this.name = name;
        this.subgroups = subgroups;
    }

    public List<SpiderCodesSubgroupInfo> getSubgroups() {
        return subgroups;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getSqlFilter() {
        if (subgroups.isEmpty()) {
            return " FALSE ";
        }
        StringBuilder filter = new StringBuilder();
        for (SpiderCodesSubgroupInfo subgroupInfo : subgroups) {
            if (filter.length() > 0) {
                filter.append(" OR ");
            }
            filter.append(" (").append(subgroupInfo.getSqlFilter()).append(") ");
        }
        return filter.toString();
    }
}
